subroutine rkf4st(t_in,t_out,y1,hin,ni,epsin,iflag)

!===============================================================
!        programmer   a.segal
!        version 1    date   12-02-82
!		 aangepast en essentieel gewijzigd: 
!    		f90, hdh 301097.
!===============================================================
!include 'link_fnl_static.h'

use CochParms
implicit NONE
SAVE

real(dbl), intent(inout)  :: t_in
real(dbl), intent(in)     :: t_out
real(dbl), intent(inout), dimension(ndim) :: y1
real(dbl), intent(inout)  :: hin
real(dbl), intent(inout)  :: epsin
integer(4), intent(inout) :: iflag
integer(4), intent(inout) :: ni

real(dbl), dimension(nBM) :: yx_out

real(dbl) :: t
real(dbl) :: alva
real(dbl) :: hn
real(dbl) :: a_local
real(dbl) :: b_local

integer(4) :: ifail, i


!  **  control input
if (iflag == 1) then
  if (ni < 1 .or. ni > 2054 .or. t_out < t_in) iflag=5
  if (epsin < 1.d-12) then        !!original: .le. or <=
	epsin=1.0d-12
	write(iwrite,1)
1   format(5x,'epsin too small, new epsin=1.0d-12')
  end if
  if (iflag == 5) then
    write(iwrite,4)
4   format(5x,'wrong input')
    return
  else
  !  **  initialize , compute appropriate step
    call rhst1(t_in,y1,yp1)
    b_local=1.0d-15
    do i=1,ni
      b_local=b_local+yp1(i)*yp1(i)
    end do
    a_local=abs(epsin/sqrt(b_local))
    hin=sqrt(a_local)
    iflag=2
  end if
else
  call rhst1(t_in,y1,yp1)
end if
!  **  end of start-phase


if (hin.gt.(t_out-t_in)) hin=t_out-t_in+1.0d-15
if (hin.gt.(0.2d-15)) goto 110

!new: use matrix format
yst4=y1 + hin*yp1

goto 200

110 continue

yst1=y1 + hin*yp1/par2
t=t_in+hin/par2
call rhst1(t,yst1,yp2)

yst2=y1 + 0.75d0*hin*yp2
t=t_in+.75d0*hin
call rhst1(t,yst2,yp3)

yst3=y1 + hin*(par2*yp1+3.d0*yp2+4.d0*yp3)/9.d0

yst2=y1 + hin*yp2/par2
t=t_in+hin/par2
call rhst1(t,yst2,yp3)

yst2=y1 + hin*yp3
t=t_in+hin
call rhst1(t,yst2,yp4)

yst4 = y1 + hin*(yp1+par2*yp2+par2*yp3+yp4)/6.0d0
b_local=1.0d-15

do i=1,ni
    a_local=abs(yst4(i)-yst3(i))
    if (a_local.gt.b_local) b_local=a_local
end do

b_local=par2*b_local
alva=b_local/epsin
if (alva.gt.1.0d4 ) alva=1.0d4
if (alva.lt.1.0d-4) alva=1.0d-4
hn=sqrt(alva)
hn=hin/sqrt(hn)
if (b_local.lt.epsin) goto 200
!  **  accuracy test failed : new stepsize
ifail=ifail+1
if (ifail.eq.3) goto 300
hin=.9*hn

goto 110

200  continue
!  **  accuracy test passed
y1=yst4
t_in=t_in+hin
b_local=t_out-t_in
if (b_local.lt.(1.0d-15)) iflag=3
hin=hn
return

 300  continue
!  **  more than three failures at this point
iflag=4
write(iwrite,310) t_in
 310  format(5x,'three failures at time=',f12.4)
return

CONTAINS

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
subroutine rhst1(t,yin,yout)
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!c
!c     routine rhst1
!c
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!c
!c     first version: october, 24th - november, 1st 1985
!c
!c     author: rob diependaal
!c
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!c
!c     computes right hand side of differential equation
!c
!c     input parameters:
!c        t-time
!c        yin-dependent variable
!c
!c     output parameters:
!c        yout-right hand side
!c
!c     common parameters: param1 (see routine sol1d1)
!c
!c     uses subroutines: dgesl
!c
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
use LSARG_INT
!use CochParms
IMPLICIT NONE
SAVE

real(8), dimension(ndim), intent(in)  :: yin
real(8), dimension(ndim), intent(out) :: yout

real*8 :: beta
!real*8 :: b1,b2
real*8 :: coef2
!real*8 :: presed
!real*8 :: resist
!real*8 :: rmass
!real*8 :: stiffn
real*8 :: sum
real(dbl),intent(inout) :: t
real*8 :: tt
real*8 :: x1
real*8 :: xx, uu, vv
!use new local yx parameter, renamed to yxloc
real(8), dimension(ndim) :: yxloc

integer*4 :: i, j

!local functions

!stiffn(xx,uu,vv)=1.d4*exp(-3.d-1*xx)
!presed(tt)=3.16d-8*sin(twopi*tt)
!rmass(xx)=5d-1
! beta(xx)=8d-2*exp(5d-2*xx)
beta(xx)=par1
!!b2(xx)=85d-2+3d-3*xx
! b2(xx)=par1
! b1(xx)=b2(xx)-beta(xx)

!allocatable (yin(ndim), yout(ndim) )

if(t.eq.tref) goto 2000
!print*,'resme= ',resme
!print*,'tref= ',tref
!print*,'stifme=',stifme

gme=resme*yin(nBM1+1)+stifme*yin(1)  !!!Note: velocity and deflection are
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!stored succesively in the same vector:
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! deflection in 1  -  nBM1
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! velocity   in nBM1+1 - 2nBM1. (2xnBM1=ndim)
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!Point 1,nBM1+1 is the middle ear.
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!cochlea starts at 2, nBM1+2
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!So any external stimulus should be in
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! yin(1),yin(nBM1+1) ????
!print*,'gme= ',gme
g(1)=resist(par0,yin(2),yin(nBM1+2),l_active)*yin(nBM1+2)+	  &
&     stiffn(par0,yin(2),yin(nBM1+2))*yin(2)
rinp=presed(t)
!print*,'size g:', size(g)

if(t.le.4.d0) rinp=rinp*exp((4.d0-t)*(t-4.d0)/2.d0)
coef2=(gme-amred*rinp)
!print*,'coef2, gme', coef2, gme
yxloc(1)=(g(1)-coef2*rha(1))/d(1)
do i=3,nBM1
  g(i-1)=resist(x(i-1),yin(i),yin(nBM1+i),l_active)*yin(nBM1+i)+ &
&     stiffn(x(i-1),yin(i),yin(nBM1+i))*yin(i)
  yxloc(i-1)=(g(i-1)-coef2*rha(i-1))/d(i-1)
end do

   call lsarg(a,yxloc,yx_out)
   yxloc=yx_out

2000 continue
do i=2,nBM1
   yout(i)=yin(nBM1+i)
   yout(nBM1+i)=yxloc(i-1)
end do
yout(1)=yin(nBM1+1)
sum=deltax*beta(par0)*rl*yxloc(1)
do j=2,nBM
   x1=x(j)
   sum=sum+2.d0*deltax*beta(x1)*(rl-x1)*yxloc(j)
end do

yout(nBM1+1)=(amred*rinp-gme-2.d0*rho/pi/b/rh*sum)/rmseff

return
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!c
!c     end of routine rhst1
!c
!ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
end subroutine rhst1




end
